import { world } from "@minecraft/server";
function onAfterPlayerSpawn(eventData) {
  if (eventData.player?.getDynamicProperty('sf_nba:player_first_spawn') == false) {
    return;
  }
  const player = eventData.player;
  player.setDynamicProperty('sf_nba:player_first_spawn', false);
  player.onScreenDisplay.setActionBar({ text: 'action.sf_nba:book.appeared' });
  player.runCommandAsync('loot spawn ^^^2 loot "sf/nba/entities/info_book.loot"');
}
function onAfterPlayerInteractWithEntity(eventData) {
  if (eventData.itemStack?.typeId !== 'sf_nba:info_book_spawn_egg') {
    return;
  }
  const player = eventData.player;
  player.runCommand("clear @s sf_nba:info_book_spawn_egg")
  const entity = eventData.target;
  const PageNumber = entity.getProperty("sf_nba:recipe_page");
  const infoBookEntity = entity.dimension.spawnEntity('sf_nba:info_book', entity.location);
  infoBookEntity.setProperty('sf_nba:recipe_page', PageNumber);
}
function onAfterItemUse(eventData) {
  if (eventData.itemStack?.typeId !== 'sf_nba:info_book') {
    return;
  }
  const player = eventData.source;
  player.runCommand('loot replace entity @s slot.weapon.mainhand 0 loot "sf/nba/info_book.loot"');
}
world.afterEvents.playerSpawn.subscribe(onAfterPlayerSpawn);
world.afterEvents.itemUse.subscribe(onAfterItemUse);